<?xml version="1.0"?>
<!-- Stylesheet converting from fujaba-xml to gxl    -->
<!-- $Id: xml2gxl.xsl,v 1.9 2004/10/20 17:50:38 schneider Exp $ -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xlink="http://www.w3.org/1999/xlink">
   
<xsl:strip-space elements="*"/>

<xsl:output method="xml" 
            omit-xml-declaration="no" 
            standalone="yes"
            doctype-system="http://www.upb.de/cs/fujaba/DTDs/gxl.dtd"
            indent="yes"/>
  
   <xsl:template match="/">
      <gxl>
         <xsl:apply-templates/>
      </gxl>
   </xsl:template>

   <xsl:template match="fujaba_export">
      <graph id="FujabaExport">
         <xsl:apply-templates/>
      </graph>
   </xsl:template>

   <xsl:template match="diagram">
      <xsl:apply-templates/>
   </xsl:template>

   <xsl:template match="object">
      <node>
         <xsl:attribute name="id">
         	<xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:apply-templates mode="simple"/>
      </node>
      <!-- generating edges here-->
      <xsl:apply-templates mode="reference"/>
   </xsl:template>
	
   <!-- only class-elements with parent-element object -->
   <xsl:template match="class" mode="reference"/>
   <xsl:template match="class[parent::object]" mode="simple">
      <type>
         <xsl:attribute name="xlink:type">simple</xsl:attribute>
         <xsl:attribute name="xlink:href"><xsl:value-of select="."/></xsl:attribute>
      </type>
   </xsl:template>

   <xsl:template match="id"/>

   <xsl:template match="value | reference">
      <string>
         <xsl:value-of select="."/>
      </string>
   </xsl:template>
	
   <xsl:template match="attribute[count(*)=1]" mode="simple">
      <xsl:if test="not(starts-with(./value/text(),'id'))">
         <attr>
            <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
            <xsl:apply-templates/>
         </attr>
      </xsl:if>
   </xsl:template>
	
   <xsl:template match="attribute[count(*)>1]" mode="simple">
      <xsl:if test="not(starts-with(./value/text(),'id'))">
         <attr>
            <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
            <seq>
               <xsl:apply-templates/>
            </seq>
         </attr>
      </xsl:if>
   </xsl:template>
	
   <xsl:template match="attribute[not(starts-with(./value/text(),'id'))]" mode="reference"/>
   
   <xsl:template match="attribute[starts-with(./value/text(),'id')]" mode="reference">
      <xsl:variable name="attrName">
         <xsl:value-of select="@name"/>
      </xsl:variable>
      <xsl:variable name="fromId">
         <xsl:value-of select="../@id"/>
      </xsl:variable>
      <xsl:variable name="toId">
         <xsl:value-of select="value/text()"/>
      </xsl:variable>
      <xsl:if test="count(../../object[@id=$toId])>0">
         <edge>
            <xsl:attribute name="from"><xsl:value-of select="$fromId"/></xsl:attribute>
            <xsl:attribute name="to"><xsl:value-of select="$toId"/></xsl:attribute>
            <type>
               <xsl:attribute name="xlink:href"><xsl:value-of select="$attrName"/></xsl:attribute>
            </type>
            <xsl:if test="count(*)>1">
               <attr name="key">
                  <string><xsl:value-of select="reference"/></string>
               </attr>
            </xsl:if>
         </edge>
      </xsl:if>
   </xsl:template>

</xsl:stylesheet>

<!--  
  $Log: xml2gxl.xsl,v $
  Revision 1.9  2004/10/20 17:50:38  schneider
  Introduction of interfaces for class diagram classes

  Revision 1.1.1.1  2004/09/20 09:12:50  cschneid
  initial version

  Revision 1.8  2003/08/13 07:32:49  mtt
  adapted stylesheet urls to new www-serv directory

  Revision 1.7  2003/04/15 06:29:49  hoven
  latest version of gxl import/export

  Revision 1.2  2002/04/24 16:42:38  hoven
  im/exporting gxl, but without validation

  Revision 1.1  2002/04/24 12:04:33  hoven
  added stylesheets

  -->
